package com.bizunited.platform.rbac.server.vo;


import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @ClassName : RoleEXtendEntity
 * @Description : 角色扩展
 * @Author : chengzhongxiang
 * @Date: 2020-09-05 15:06
 */
@ApiModel(value="RoleExtendVo",description="角色拓展VO")
public class RoleExtendVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = 5180951737361105044L;

  @ApiModelProperty(name="roleVo" , value="角色Vo")
  @SaturnColumn(description="角色id")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private RoleVo roleVo;

  @ApiModelProperty(name="deleteFlag" , value="逻辑删除标志,0为未删除 1为已删除")
  @SaturnColumn(description = "逻辑删除标志")
  private Integer deleteFlag;

  @ApiModelProperty(name="createUser" , value="创建人")
  @SaturnColumn(description = "创建人", nullable = false)
  private String createUser;

  @ApiModelProperty(name="createTime" , value="创建时间")
  @SaturnColumn(description = "创建时间", nullable = false)
  private Date createTime = new Date();

  public RoleVo getRoleVo() {
    return roleVo;
  }

  public void setRoleVo(RoleVo roleVo) {
    this.roleVo = roleVo;
  }

  public Integer getDeleteFlag() {
    return deleteFlag;
  }

  public void setDeleteFlag(Integer deleteFlag) {
    this.deleteFlag = deleteFlag;
  }

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
