package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.List;

/**
 * 职级绑定角色监听器
 * @Author : chengzhongxiang
 * @Date: 2020-09-28 14:09
 */
@Component("PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener implements PositionLevelEventListener {

  @Autowired
  private RolePositionLevelMappingService rolePositionLevelMappingService;

  /**
   * 在职级创建时触发监听器，绑定角色
   * @param positionLevel
   */
  @Override
  @Transactional
  public void onPositionLevelCreated(PositionLevelVo positionLevel) {
    List<String> roleIds = ObjectUtils.defaultIfNull(positionLevel.getRoleIds(), Lists.newArrayList());
    String[] roleIdsArray = roleIds.toArray(new String[roleIds.size()]);
    rolePositionLevelMappingService.bindPositionLevelRoles(positionLevel.getCode(), roleIdsArray);
  }

  /**
   * 在职级更新时触发监听器，更新绑定角色
   * @param positionLevel
   */
  @Override
  @Transactional
  public void onPositionLevelUpdated(PositionLevelVo positionLevel) {
    List<String> roleIds = ObjectUtils.defaultIfNull(positionLevel.getRoleIds(), Lists.newArrayList());
    String[] roleIdsArray = roleIds.toArray(new String[roleIds.size()]);
    rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevel.getCode(), roleIdsArray);
  }
}
