/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.google.common.collect.Lists;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener
implements PositionLevelEventListener {
    @Autowired
    private RolePositionLevelMappingService rolePositionLevelMappingService;

    @Transactional
    public void onPositionLevelCreated(PositionLevelVo positionLevel) {
        List roleIds = (List)ObjectUtils.defaultIfNull((Object)positionLevel.getRoleIds(), (Object)Lists.newArrayList());
        String[] roleIdsArray = roleIds.toArray(new String[roleIds.size()]);
        this.rolePositionLevelMappingService.bindPositionLevelRoles(positionLevel.getCode(), roleIdsArray);
    }

    @Transactional
    public void onPositionLevelUpdated(PositionLevelVo positionLevel) {
        List roleIds = (List)ObjectUtils.defaultIfNull((Object)positionLevel.getRoleIds(), (Object)Lists.newArrayList());
        String[] roleIdsArray = roleIds.toArray(new String[roleIds.size()]);
        this.rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevel.getCode(), roleIdsArray);
    }
}

