/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionEventListener;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserRelationVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="RolePositionEventListenerImpl")
public class RolePositionBindListener
implements PositionEventListener {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RolePositionMappingService rolePositionMappingService;

    @Transactional
    public void onPositionCreate(UserRelationVo userRelation) {
        Validate.notNull((Object)userRelation, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionVo position = this.positionService.findByCode(userRelation.getPositionCode());
        Validate.notNull((Object)position, (String)"\u7f16\u7801[%s]\u7684\u804c\u4f4d\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{userRelation.getPositionCode()});
        List<String> roleIds = this.buildBindRoleIds(position, userRelation);
        if (CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        this.rolePositionMappingService.rebindPositionRoles(position.getCode(), roleIds.toArray(new String[roleIds.size()]));
    }

    @Transactional
    public void onUnbindUser(UserRelationVo userRelation) {
        Validate.notNull((Object)userRelation, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PositionVo position = this.positionService.findByCode(userRelation.getPositionCode());
        Validate.notNull((Object)position, (String)"\u7f16\u7801[%s]\u7684\u804c\u4f4d\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{userRelation.getPositionCode()});
        List<String> roleIds = this.buildBindRoleIds(position, userRelation);
        if (CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        this.rolePositionMappingService.unbindPositionRoles(position.getCode(), roleIds.toArray(new String[roleIds.size()]));
    }

    private List<String> buildBindRoleIds(PositionVo position, UserRelationVo userRelation) {
        Validate.notNull((Object)position, (String)"\u804c\u4f4d\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userRelation, (String)"\u804c\u4f4d-\u89d2\u8272-\u7528\u6237\u5173\u7cfb\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)userRelation.getAuthorityRoleCode())) {
            return Lists.newArrayList();
        }
        ArrayList roleIds = Lists.newArrayList();
        HashSet roleCodes = Sets.newHashSet(Arrays.asList(userRelation.getAuthorityRoleCode().split(",")));
        Set<RoleVo> authorityRoles = this.roleService.findByRoleCodes(roleCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(authorityRoles) && authorityRoles.size() == roleCodes.size() ? 1 : 0) != 0, (String)"\u672c\u6b21\u7ed1\u5b9a\u7684\u8fd9\u4e9b\u89d2\u8272\u3010%s\u3011\u4e2d\uff0c\u6709\u4e9b\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{userRelation.getAuthorityRoleCode()});
        authorityRoles.forEach(role -> roleIds.add(role.getId()));
        return roleIds;
    }
}

