package com.bizunited.platform.rbac.cas.starter.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * Cas的配置信息放在这里以便维护
 * @author yinwenjie
 */
@Configuration
@Component
public class CasProperties {
  /**
   * cas server的登录页面路径 
   */
  @Value("${cas.server.loginUrl}")
  private String casServerLoginUrl;
  /**
   * cas服务的票据验证地址
   */
  @Value("${cas.server.url}")
  private String casServerUrl;
  /**
   * cas验证成功后，向本应用程序的回调地址
   */
  @Value("${cas.client.loginUrl}")
  private String appLoginUrl;
  /**
   * cas成功后，本应用程序的最终欢迎页面
   */
  @Value("${cas.client.welcomeUrl}")
  private String appWelcomeUrl;
  
  public String getCasServerLoginUrl() {
    return casServerLoginUrl;
  }
  public void setCasServerLoginUrl(String casServerLoginUrl) {
    this.casServerLoginUrl = casServerLoginUrl;
  }
  public String getCasServerUrl() {
    return casServerUrl;
  }
  public void setCasServerUrl(String casServerUrl) {
    this.casServerUrl = casServerUrl;
  }
  public String getAppLoginUrl() {
    return appLoginUrl;
  }
  public void setAppLoginUrl(String appLoginUrl) {
    this.appLoginUrl = appLoginUrl;
  }
  public String getAppWelcomeUrl() {
    return appWelcomeUrl;
  }
  public void setAppWelcomeUrl(String appWelcomeUrl) {
    this.appWelcomeUrl = appWelcomeUrl;
  }
}
