/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.service.security;

import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CustomFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private RoleService roleService;
    @Value(value="${author.ignoreUrls}")
    private String[] ignoreUrls;
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        ArrayList<ConfigAttribute> configs = new ArrayList<ConfigAttribute>();
        FilterInvocation filterInvocation = (FilterInvocation)object;
        HttpServletRequest httpRequest = filterInvocation.getHttpRequest();
        for (String ignoreUrl : this.ignoreUrls) {
            AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
            if (!requestMatcher.matches(httpRequest)) continue;
            return configs;
        }
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        Set requestMappings = pathMapping.keySet();
        ArrayList matchingResults = Lists.newArrayList();
        for (Object requestMappingInfo : requestMappings) {
            RequestMappingInfo current = requestMappingInfo.getMatchingCondition(httpRequest);
            if (current == null) continue;
            matchingResults.add(current);
        }
        if (matchingResults.isEmpty()) {
            return configs;
        }
        ArrayList currentCompetences = Lists.newArrayList();
        for (RequestMappingInfo requestMappingInfo : matchingResults) {
            String resource = requestMappingInfo.getName();
            List dbCompetences = this.competenceService.findByResource(resource, Integer.valueOf(1));
            if (dbCompetences == null || dbCompetences.isEmpty()) continue;
            currentCompetences.addAll(dbCompetences);
        }
        if (currentCompetences.isEmpty()) {
            return configs;
        }
        String currentMethod = httpRequest.getMethod();
        for (CompetenceVo competence : currentCompetences) {
            List roles;
            String methods = competence.getMethods();
            if (methods.indexOf(currentMethod) == -1 || (roles = this.roleService.findByCompetenceId(competence.getId())) == null || roles.isEmpty()) continue;
            for (RoleVo role : roles) {
                SecurityConfig securityConfig = new SecurityConfig(role.getRoleName());
                configs.add((ConfigAttribute)securityConfig);
            }
        }
        return configs;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

