package com.bizunited.platform.rbac.cas.starter.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;
import com.bizunited.platform.rbac.cas.starter.configuration.CasSecurityConfig;
import com.bizunited.platform.rbac.cas.starter.configuration.WebSecurityConfig;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service可以通过表单引擎直接向表单模板开放
 * @author yinwenjie
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import({CasSecurityConfig.class , WebSecurityConfig.class , CasProperties.class})
public @interface EnableKuiperCasSecurity {

}