/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.service.security;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class CustomAccessDecisionManager
implements AccessDecisionManager {
    @Value(value="${author.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${author.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        Collection currentAuthors = authentication.getAuthorities();
        if (currentAuthors == null || currentAuthors.isEmpty()) {
            throw new AccessDeniedException("not found any author from this single in user!");
        }
        for (GrantedAuthority grantedAuthority : currentAuthors) {
            for (String ignoreMethodCheckRole : this.ignoreMethodCheckRoles) {
                if (!StringUtils.equals((CharSequence)grantedAuthority.getAuthority(), (CharSequence)ignoreMethodCheckRole)) continue;
                return;
            }
        }
        FilterInvocation filterInvocation = (FilterInvocation)object;
        HttpServletRequest request = filterInvocation.getHttpRequest();
        for (String ignoreUrl : this.ignoreUrls) {
            AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
            if (!requestMatcher.matches(request)) continue;
            return;
        }
        if (configAttributes == null || configAttributes.isEmpty()) {
            return;
        }
        for (ConfigAttribute securityConfig : configAttributes) {
            for (GrantedAuthority grantedAuthority : currentAuthors) {
                if (!StringUtils.equals((CharSequence)securityConfig.getAttribute(), (CharSequence)grantedAuthority.getAuthority())) continue;
                return;
            }
        }
        throw new AccessDeniedException("not author!");
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

