/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.service.security;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CustomLogoutHandle
implements LogoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomLogoutHandle.class);

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        LOGGER.info("====\u767b\u51fa\u6210\u529f\u5f00\u59cblogoutSuccess====");
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        LOGGER.info("\u5f53\u524dsessionId={}", (Object)sessionId);
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (int index = 0; index < allCookies.length; ++index) {
                LOGGER.info("\u767b\u51fa\u7684cookie \uff1a{} || value = {}", (Object)allCookies[index].getName(), (Object)allCookies[index].getValue());
                Cookie currentCookie = allCookies[index];
                this.deleteCookies(sessionId, response, currentCookie);
            }
        }
        LOGGER.info("====\u767b\u51fa\u6210\u529f\u7ed3\u675flogoutSuccess====");
    }

    private void deleteCookies(String sessionId, HttpServletResponse response, Cookie cookie) {
        switch (cookie.getName()) {
            case "account": 
            case "context-path": 
            case "redirectUrl": 
            case "persistence": {
                this.invalidCookie(response, cookie);
                break;
            }
            case "JSESSIONID": 
            case "SESSION": {
                if (!StringUtils.equals((CharSequence)sessionId, (CharSequence)cookie.getValue())) break;
                this.invalidCookie(response, cookie);
                break;
            }
        }
    }

    private void invalidCookie(HttpServletResponse response, Cookie cookie) {
        LOGGER.info("\u5220\u9664cookie = {} || value = {}", (Object)cookie.getName(), (Object)cookie.getValue());
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }
}

