/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.service.security;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CustomLogoutHandle
implements LogoutHandler {
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (int index = 0; index < allCookies.length; ++index) {
                Cookie currentCookie = allCookies[index];
                this.deleteCookies(sessionId, response, currentCookie);
            }
        }
    }

    private void deleteCookies(String sessionId, HttpServletResponse response, Cookie cookie) {
        switch (cookie.getName()) {
            case "account": 
            case "context-path": 
            case "redirectUrl": 
            case "persistence": {
                this.invalidCookie(response, cookie);
                break;
            }
            case "JSESSIONID": 
            case "SESSION": {
                if (!StringUtils.equals((CharSequence)sessionId, (CharSequence)cookie.getValue())) break;
                this.invalidCookie(response, cookie);
                break;
            }
        }
    }

    private void invalidCookie(HttpServletResponse response, Cookie cookie) {
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }
}

