package com.bizunited.platform.rbac.cas.starter.service.security;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CustomLogoutHandle implements LogoutHandler{

  /**
   * 登出逻辑的处理过程为：
   * 1.删除表单再casSuccess登入时，写入的cookies信息
   * 2.涉及到的cookies信息key为：account，context-path，redirectUrl，persistence，JSESSIONID，SESSION
   * 3.其中JSESSIONID，SESSION是表单引擎存储的，需要辨别。不能把其他系统存储的JSESSIONID，SESSION删除掉
   * 注：cookies的清理逻辑只能再登出handle里进行，不能再登出成功的handle进行
   */
  @Override
  public void logout(HttpServletRequest request, HttpServletResponse response,
      Authentication authentication) {
    HttpSession session = request.getSession();
    String sessionId = session.getId();
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        deleteCookies(sessionId ,response,currentCookie);
      }
    }
  }
  
  /**
   * 删除cookies
   * @param sessionId
   * @param response
   * @param cookie
   */
  private void deleteCookies(String sessionId ,HttpServletResponse response,Cookie cookie) {
    switch (cookie.getName()) {
      case "account":
      case "context-path":
      case "redirectUrl":
      case "persistence":
        invalidCookie(response,cookie);
        break;
      case "JSESSIONID":
      case "SESSION":
        if(StringUtils.equals(sessionId, cookie.getValue())) {
          invalidCookie(response,cookie);
        }
        break;
      default:
        break;
    }
  }
  
  /**
   * 删除cookie
   * @param response
   * @param cookie
   */
  private void invalidCookie(HttpServletResponse response,Cookie cookie) {
    cookie.setMaxAge(0);
    cookie.setPath("/");
    response.addCookie(cookie); 
  }

}
