package com.bizunited.platform.rbac.cas.starter.configuration;

import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

import com.bizunited.platform.rbac.cas.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.cas.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.cas.starter.service.security.CustomUserSecurityDetailsService;

/**
 * Cas client配置信息
 * @author yinwenjie
 */
@Configuration
//启动spring session
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:")
@ComponentScan(basePackages= {"com.bizunited.platform.rbac","com.bizunited.platform.core"})
public class CasSecurityConfig {
  @Autowired
  private CasProperties casProperties;
  
  @Bean
  public CasAuthenticationEntryPoint casAuthenticationEntryPoint() {
    CasAuthenticationEntryPoint casAuthenticationEntryPoint = new CasAuthenticationEntryPoint();
    casAuthenticationEntryPoint.setLoginUrl(casProperties.getCasServerLoginUrl());
    casAuthenticationEntryPoint.setServiceProperties(serviceProperties());
    return casAuthenticationEntryPoint;
  }

  /**
   * 指定service相关信息
   */
  @Bean
  public ServiceProperties serviceProperties() {
    ServiceProperties serviceProperties = new ServiceProperties();
    serviceProperties.setService(casProperties.getAppLoginUrl());
    serviceProperties.setAuthenticateAllArtifacts(true);
    return serviceProperties;
  }
  
  /**
   * cas 认证 Provider
   */
  @Bean
  public CasAuthenticationProvider casAuthenticationProvider() {
    CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
    casAuthenticationProvider.setUserDetailsService(getUserDetailsService());
    casAuthenticationProvider.setServiceProperties(serviceProperties());
    casAuthenticationProvider.setTicketValidator(cas20ServiceTicketValidator());
    casAuthenticationProvider.setKey("casAuthenticationProviderKey");
    return casAuthenticationProvider;
  }
  
  @Bean(name="UserDetailsService")
  public UserDetailsService getUserDetailsService(){
    return new CustomUserSecurityDetailsService();
  }
  @Bean(name="CustomAccessDecisionManager")
  public CustomAccessDecisionManager getCustomAccessDecisionManager() {
    return new CustomAccessDecisionManager();
  }
  @Bean(name="CustomFilterInvocationSecurityMetadataSource")
  public CustomFilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
    return new CustomFilterInvocationSecurityMetadataSource();
  }
  @Bean
  public Cas20ServiceTicketValidator cas20ServiceTicketValidator() {
    return new Cas20ServiceTicketValidator(casProperties.getCasServerUrl());
  }

  /**
   * 单点登出过滤器
   */
  @Bean
  public SingleSignOutFilter singleSignOutFilter() {
    SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
    singleSignOutFilter.setCasServerUrlPrefix(casProperties.getCasServerUrl());
    singleSignOutFilter.setIgnoreInitConfiguration(true);
    return singleSignOutFilter;
  }

  /**
   * 请求单点退出过滤器
   */
  @Bean
  public LogoutFilter casLogoutFilter() {
    LogoutFilter logoutFilter = new LogoutFilter(casProperties.getCasServerLogoutUrl(), new SecurityContextLogoutHandler());
    logoutFilter.setFilterProcessesUrl(casProperties.getAppLogoutUrl());
    return logoutFilter;
  }
}