package com.bizunited.platform.rbac.cas.starter.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;

import com.bizunited.platform.rbac.server.crypto.password.Aes2PasswordEncoder;

@Configuration
public class PasswordEncoderConfig {
  /**
   * 用户密码的默认加密方式为PBKDF2加密
   * @return
   */
  @Bean(name="passwordEncoder")
  @Primary
  public PasswordEncoder passwordEncoder() {
    return new Pbkdf2PasswordEncoder();
  }
  
  @Bean(name="aes2PasswordEncoder")
  public Aes2PasswordEncoder getAes2PasswordEncoder() {
    return new Aes2PasswordEncoder();
  }
}
