package com.bizunited.platform.rbac.cas.starter.controller;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;

import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/v1/rbac")
public class LogoutController extends BaseController {
  @Autowired
  private CasProperties casProperties;
  
  @ApiOperation(value="该请求负责在cas-client场景下，进行系统登录")
  @RequestMapping(value="/logout" , method={RequestMethod.GET , RequestMethod.POST})
  public ResponseModel logout(HttpSession session) {
    session.invalidate();
    
    // 退出后，通知cas鉴权中心进行退出。
    String service = null;
    URL logoutUrl = null;
    String casServerLogoutUrl = this.casProperties.getCasServerLogoutUrl();
    try {
      service = URLEncoder.encode(this.casProperties.getAppLogoutUrl() , "UTF-8");
      logoutUrl = new URL(casServerLogoutUrl);
      new URL(this.casProperties.getCasServerLogoutUrl());
    } catch (UnsupportedEncodingException | MalformedURLException e) {
      ResponseModel result =  super.buildHttpResultForException(e);
      result.setSuccess(false);
      result.setData(casServerLogoutUrl);
      result.setMessage(casServerLogoutUrl);
    }
    
    // 确认跳转的cas登出路径，并完成跳转
    if(StringUtils.isBlank(logoutUrl.getQuery())) {
      casServerLogoutUrl += "?service=" + service;
    } else { 
      casServerLogoutUrl += "&service=" + service;
    } 
    ResponseModel result = super.buildHttpResult();
    result.setData(casServerLogoutUrl);
    result.setMessage(casServerLogoutUrl);
    result.setSuccess(true);
    return result;
  }
}
