package com.bizunited.platform.rbac.cas.starter.handle;

import java.io.IOException;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;

public class AbstractHttpHandle {
  /**
   * 该支持方法，用于清理本地客户端的cookies信息
   * @param request
   * @param response
   */
  protected void clearCookies(HttpServletRequest request, HttpServletResponse response) {
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        currentCookie.setMaxAge(0);
        response.addCookie(currentCookie);
      }
    }
  }
  
  /**
   * 该支持方法，向页面输出一段基于http协议的json信息
   * @param response
   * @param result
   * @throws IOException
   */
  protected void writeResponse(HttpServletResponse response , ResponseModel result) throws IOException {
    response.setContentType("application/json;charset=UTF-8");
    response.getWriter().write(JsonUtils.obj2JsonString(result));
  }
}
