package com.bizunited.platform.rbac.cas.starter.handle;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;

/**
 * 重写了访问请求无权限时或者登录信息过期时的异常处理器，请注意，只有在鉴权并明确抛出AccessDeniedException异常时，该处理器才会生效
 * @author yinwenjie
 *
 */
public class SimpleAccessDeniedHandler extends AbstractHttpHandle implements AuthenticationEntryPoint , AccessDeniedHandler , InitializingBean {
  
  private static final String SESSION_USER_MISS = "用户已失效或未登录!";
  
  private static final String SESSION_DENIED = "用户无权访问该功能!";

  /**
   * CAS的配置信息
   */
  @Autowired
  private CasProperties casProperties;
  
  @Override
  public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
    // 清理cookies
    super.clearCookies(request, response);
    // 返回编码
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E601,new IllegalAccessException(SESSION_USER_MISS));
    String deniedRedirect = casProperties == null ? "" : casProperties.getCasServerLoginUrl();
    // cas单点登录成功后，往哪里跳
    String appLoginUrl = casProperties.getAppLoginUrl();
    String service = URLEncoder.encode(appLoginUrl, "UTF-8");
    
    // 形成最终的返回结果中的data信息
    URL deniedRedirectUrl = new URL(deniedRedirect);
    if(StringUtils.isBlank(deniedRedirectUrl.getQuery())) {
      deniedRedirect += "?service=" + service;
    } else {
      deniedRedirect += "&service=" + service;
    }
    result.setData(deniedRedirect);
    this.writeResponse(response, result);
  }

  @Override
  public void afterPropertiesSet() throws Exception {
  }

  @Override
  public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
    // 清理cookies
    super.clearCookies(request, response);
    // 返回编码
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E602,new IllegalAccessException(SESSION_DENIED));
    String deniedRedirect = casProperties == null ? "" : casProperties.getCasServerLoginUrl();
    // cas单点登录成功后，往哪里跳
    String appLoginUrl = casProperties.getAppLoginUrl();
    String service = URLEncoder.encode(appLoginUrl, "UTF-8");
    
    // 形成最终的返回结果中的data信息
    URL deniedRedirectUrl = new URL(deniedRedirect);
    if(StringUtils.isBlank(deniedRedirectUrl.getQuery())) {
      deniedRedirect += "?service=" + service;
    } else {
      deniedRedirect += "&service=" + service;
    }
    result.setData(deniedRedirect);
    this.writeResponse(response, result);
  }
}