package com.bizunited.platform.rbac.cas.starter.handle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

/**
 * 登出成功后，触发该handle</br>
 * 用于登出系统，并按照设定信息，跳转到指定的登陆后页面。所谓登录实际上就是清楚当前系统的cookies信息
 * @author yinwenjie
 */
public class SimpleLogoutSuccessHandler extends AbstractHttpHandle implements LogoutSuccessHandler {
  @Autowired
  private CasProperties casProperties;
  
  @Override
  public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
    /*
     * 做两件事情：
     * 1、清除相关的cookes
     * 2、向客户端返回http 607的编码提示
     * */
    super.clearCookies(request, response);
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E607,null);
    // 退出到cas server的默认登录页面
    String deniedRedirect = casProperties == null ? "" : casProperties.getCasServerLoginUrl();
    result.setData(deniedRedirect);
    this.writeResponse(response, result);
  }
}
