package com.bizunited.platform.rbac.cas.starter.service.security;

import java.util.List;

import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

import com.google.common.collect.Lists;

/**
 * 这个自定义的用户信息查询服务（权限模块使用），用来查询指定的用户详情（包括角色信息）
 * @author yinwenjie
 */
public class CustomUserSecurityDetailsService implements UserDetailsService,  AuthenticationUserDetailsService<CasAssertionAuthenticationToken> {
  
  /* (non-Javadoc)
   * @see org.springframework.security.core.userdetails.UserDetailsService#loadUserByUsername(java.lang.String)
   */
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    List<SimpleGrantedAuthority> authorities = Lists.newArrayList(new SimpleGrantedAuthority("ADMIN"));
    // 角色信息形成authorities集合对象（密码不在重要了）
    return new User(username, "111111", authorities);
  }

  @Override
  public UserDetails loadUserDetails(CasAssertionAuthenticationToken token) throws UsernameNotFoundException {
    return this.loadUserByUsername(token.getName());
  }
}
