/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.configuration;

import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;
import com.bizunited.platform.rbac.cas.starter.handle.SimpleAccessDeniedHandler;
import com.bizunited.platform.rbac.cas.starter.handle.SimpleLogoutSuccessHandler;
import com.bizunited.platform.rbac.cas.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.cas.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.cas.starter.service.security.CustomUserSecurityDetailsService;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:")
@ComponentScan(basePackages={"com.bizunited.platform.rbac", "com.bizunited.platform.core"})
public class CasSecurityConfig {
    @Autowired
    private CasProperties casProperties;

    @Bean(name={"AuthenticationEntryPoint"})
    @ConditionalOnMissingBean
    public AuthenticationEntryPoint casAuthenticationEntryPoint() {
        CasAuthenticationEntryPoint casAuthenticationEntryPoint = new CasAuthenticationEntryPoint();
        casAuthenticationEntryPoint.setLoginUrl(this.casProperties.getCasServerLoginUrl());
        casAuthenticationEntryPoint.setServiceProperties(this.serviceProperties());
        return casAuthenticationEntryPoint;
    }

    @Bean
    public ServiceProperties serviceProperties() {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(this.casProperties.getAppLoginUrl());
        serviceProperties.setAuthenticateAllArtifacts(true);
        return serviceProperties;
    }

    @Bean(name={"AuthenticationProvider"})
    public CasAuthenticationProvider casAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setUserDetailsService(this.getUserDetailsService());
        casAuthenticationProvider.setServiceProperties(this.serviceProperties());
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = this.cas20ServiceTicketValidator();
        cas20ServiceTicketValidator.setEncoding("UTF-8");
        casAuthenticationProvider.setTicketValidator((TicketValidator)cas20ServiceTicketValidator);
        casAuthenticationProvider.setKey("casAuthenticationProviderKey");
        return casAuthenticationProvider;
    }

    @Bean(name={"UserDetailsService"})
    public UserDetailsService getUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"CustomAccessDecisionManager"})
    public CustomAccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"CustomFilterInvocationSecurityMetadataSource"})
    public CustomFilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean(name={"AccessDeniedHandler"})
    @ConditionalOnMissingBean
    public SimpleAccessDeniedHandler getSimpleAccessDeniedHandler() {
        return new SimpleAccessDeniedHandler();
    }

    @Bean
    public Cas20ServiceTicketValidator cas20ServiceTicketValidator() {
        return new Cas20ServiceTicketValidator(this.casProperties.getCasServerUrl());
    }

    @Bean
    public Cas30ServiceTicketValidator cas30ServiceTicketValidator() {
        return new Cas30ServiceTicketValidator(this.casProperties.getCasServerUrl());
    }

    @Bean
    public SingleSignOutFilter singleSignOutFilter() {
        SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
        singleSignOutFilter.setCasServerUrlPrefix(this.casProperties.getCasServerUrl());
        singleSignOutFilter.setIgnoreInitConfiguration(true);
        return singleSignOutFilter;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogoutSuccessHandler logoutSuccessHandler() {
        return new SimpleLogoutSuccessHandler();
    }
}

