/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.handle;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;
import com.bizunited.platform.rbac.cas.starter.handle.AbstractHttpHandle;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public class SimpleAccessDeniedHandler
extends AbstractHttpHandle
implements AuthenticationEntryPoint,
AccessDeniedHandler,
InitializingBean {
    private static final String SESSION_USER_MISS = "\u7528\u6237\u5df2\u5931\u6548\u6216\u672a\u767b\u5f55!";
    private static final String SESSION_DENIED = "\u7528\u6237\u65e0\u6743\u8bbf\u95ee\u8be5\u529f\u80fd!";
    @Autowired
    private CasProperties casProperties;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        super.clearCookies(request, response);
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E601, (Throwable)new IllegalAccessException(SESSION_USER_MISS));
        String deniedRedirect = this.casProperties == null ? "" : this.casProperties.getCasServerLoginUrl();
        String appLoginUrl = this.casProperties.getAppLoginUrl();
        String service = URLEncoder.encode(appLoginUrl, "UTF-8");
        URL deniedRedirectUrl = new URL(deniedRedirect);
        deniedRedirect = StringUtils.isBlank((CharSequence)deniedRedirectUrl.getQuery()) ? deniedRedirect + "?service=" + service : deniedRedirect + "&service=" + service;
        result.setData((Object)deniedRedirect);
        this.writeResponse(response, result);
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        super.clearCookies(request, response);
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E602, (Throwable)new IllegalAccessException(SESSION_DENIED));
        String deniedRedirect = this.casProperties == null ? "" : this.casProperties.getCasServerLoginUrl();
        String appLoginUrl = this.casProperties.getAppLoginUrl();
        String service = URLEncoder.encode(appLoginUrl, "UTF-8");
        URL deniedRedirectUrl = new URL(deniedRedirect);
        deniedRedirect = StringUtils.isBlank((CharSequence)deniedRedirectUrl.getQuery()) ? deniedRedirect + "?service=" + service : deniedRedirect + "&service=" + service;
        result.setData((Object)deniedRedirect);
        this.writeResponse(response, result);
    }
}

