/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.handle;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class SimpleLogoutSuccessHandler
implements LogoutSuccessHandler {
    @Value(value="${rbac.logoutSuccessRedirect:/default/index.html}")
    private String logoutSuccessRedirect;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (int index = 0; index < allCookies.length; ++index) {
                Cookie currentCookie = allCookies[index];
                currentCookie.setMaxAge(0);
                response.addCookie(currentCookie);
            }
        }
        response.sendRedirect(this.logoutSuccessRedirect);
    }
}

