package com.bizunited.platform.rbac.cas.starter.handle;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 登出成功后，触发该handle</br>
 * 用于登出系统，并按照设定信息，跳转到指定的登陆后页面。所谓登录实际上就是清楚当前系统的cookies信息
 * @author yinwenjie
 *
 */
public class SimpleLogoutSuccessHandler implements LogoutSuccessHandler {

  /**
   * 登出成功后重定向地址
   */
  @Value("${rbac.logoutSuccessRedirect:/default/index.html}")
  private String logoutSuccessRedirect;

  @Override
  public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
    /*
     * 做两件事情：
     * 1、清除相关的cookes
     * 2、向前端调用者返回登出成功的提示信息
     * */
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        currentCookie.setMaxAge(0);
        response.addCookie(currentCookie);
      }
    }
    response.sendRedirect(logoutSuccessRedirect);
  }
}
