/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.cas.starter.configuration;

import com.bizunited.platform.rbac.cas.starter.configuration.CasProperties;
import java.util.Arrays;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private AuthenticationProvider authenticationProvider;
    @Autowired
    private SingleSignOutFilter singleSignOutFilter;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Value(value="${rbac.ignoreUrls}")
    private String[] ignoreUrls;
    @Autowired
    private CasProperties casProperties;
    @Value(value="${rbac.loginUrl}")
    private String loginUrl;
    @Value(value="${rbac.logoutUrl:/v1/rbac/logout}")
    private String logoutUrl;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.headers().frameOptions().disable().and()).authorizeRequests().antMatchers(this.ignoreUrls)).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).httpBasic().authenticationEntryPoint(this.authenticationEntryPoint).and()).logout().logoutUrl(this.logoutUrl).logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).addFilterBefore((Filter)this.singleSignOutFilter, CasAuthenticationFilter.class);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        super.configure(auth);
        auth.authenticationProvider(this.authenticationProvider);
    }

    protected AuthenticationManager authenticationManager() throws Exception {
        return new ProviderManager(Arrays.asList(this.authenticationProvider));
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter(ServiceProperties sp) {
        CasAuthenticationFilter filter = new CasAuthenticationFilter();
        AuthenticationManager authenticationManager = null;
        try {
            authenticationManager = this.authenticationManager();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        filter.setServiceProperties(sp);
        filter.setAuthenticationManager(authenticationManager);
        filter.setFilterProcessesUrl(this.casProperties.getAppLoginUrl());
        filter.setContinueChainBeforeSuccessfulAuthentication(false);
        return filter;
    }

    @Bean(name={"passwordEncoder"})
    public PasswordEncoder passwordEncoder() {
        return new Pbkdf2PasswordEncoder();
    }
}

