package com.bizunited.platform.rbac.okta.starter.controller;

import com.bizunited.platform.rbac.security.starter.handle.ResponseCode;
import com.bizunited.platform.rbac.security.starter.handle.ResponseModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

/**
 * rbac的接口实现，实现登出接口的处理
 * @Author: Paul Chan
 * @Date: 2020-03-10 15:04
 */
@RestController
@RequestMapping("/v1/rbac")
public class logoutController {

  /**
   * 登出操作地址
   */
  @Value("${rbac.logoutSuccessRedirect:}")
  private String logoutSuccessRedirect;

  @GetMapping("logout")
  private ResponseModel logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
    new SecurityContextLogoutHandler().logout(request, null, null);
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        currentCookie.setMaxAge(0);
        response.addCookie(currentCookie);
      }
    }
    ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
    result.setSuccess(true);
    result.setMessage(logoutSuccessRedirect);
    return result;
  }

}
