package com.bizunited.platform.rbac.okta.starter.handle;

import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.user.OAuth2User;

/**
 * 默认的新用户处理
 * @Author: Paul Chan
 * @Date: 2020-03-13 15:20
 */
public class SimpleOnNewUserHandler implements OnNewUserHandler {

  @Autowired
  private UserService userService;

  @Override
  public UserVo handle(OAuth2User oAuth2User) {
    UserVo currentUser = new UserVo();
    currentUser.setAccount(oAuth2User.getName());
    currentUser.setUserName(oAuth2User.getName());
    currentUser.setPassword("12345678");
    currentUser.setPhone("");
    currentUser = userService.create(currentUser);
    return currentUser;
  }

}
