/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.configuration;

import com.bizunited.platform.rbac.okta.starter.handle.SimpleAccessDeniedHandler;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterSecurityInterceptor;
import java.util.Arrays;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
public class OktaWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Value(value="${rbac.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${rbac.loginUrl}")
    private String loginUrl;
    @Value(value="${rbac.logoutUrl}")
    private String logoutUrl;
    @Autowired
    private OAuth2UserService oidcUserService;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AccessDecisionManager accessDecisionManager;
    @Lazy
    @Autowired
    private FilterInvocationSecurityMetadataSource securityMetadataSource;
    @Autowired(required=false)
    private ClientRegistrationRepository clientRegistrationRepository;

    protected void configure(HttpSecurity http) throws Exception {
        CustomFilterSecurityInterceptor filterSecurityInterceptor = new CustomFilterSecurityInterceptor(this.securityMetadataSource, this.accessDecisionManager, super.authenticationManager());
        CorsConfigurationSource configurationSource = this.corsConfigurationSource();
        SimpleAccessDeniedHandler simpleAccessDeniedHandler = new SimpleAccessDeniedHandler(this.clientRegistrationRepository);
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.addFilterAt((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class).cors().configurationSource(configurationSource).and()).headers().frameOptions().disable().and()).authorizeRequests().antMatchers(this.ignoreUrls)).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)simpleAccessDeniedHandler).and()).logout().logoutUrl(this.logoutUrl).permitAll().and()).oauth2Client().and()).oauth2Login().userInfoEndpoint().oidcUserService(this.oidcUserService);
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
    }

    @Autowired
    public void globalUserDetails(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder());
        auth.parentAuthenticationManager(this.authenticationManagerBean());
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean(name={"passwordEncoder"})
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new Pbkdf2PasswordEncoder();
    }
}

