/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.service.security;

import com.bizunited.platform.rbac.okta.starter.handle.OnNewUserHandler;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class OktaOauth2UserSecurityDetailsService
extends OidcUserService {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OnNewUserHandler onNewUserHandler;

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = super.loadUser(userRequest);
        UserVo currentUser = this.userService.findByAccount(oidcUser.getName());
        if (currentUser == null) {
            currentUser = this.onNewUserHandler.handle((OAuth2User)oidcUser);
        }
        List roles = null;
        roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
        if (roles == null || roles.isEmpty()) {
            throw new UsernameNotFoundException("\u7528\u6237\u6743\u9650\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\uff01");
        }
        LinkedList<SimpleGrantedAuthority> authorities = new LinkedList<SimpleGrantedAuthority>();
        for (RoleVo role : roles) {
            SimpleGrantedAuthority authoritie = new SimpleGrantedAuthority(role.getRoleName());
            authorities.add(authoritie);
        }
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        if (StringUtils.isNotBlank((CharSequence)userNameAttributeName)) {
            return new DefaultOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName);
        }
        return new DefaultOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo());
    }
}

