/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.configuration;

import com.bizunited.platform.rbac.okta.starter.handle.Oauth2UserHandler;
import com.bizunited.platform.rbac.okta.starter.handle.SimpleOauth2UserHandler;
import com.bizunited.platform.rbac.okta.starter.okta.OktaOAuth2Properties;
import com.bizunited.platform.rbac.okta.starter.service.security.OktaOauth2UserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationDetailsSource;
import javax.servlet.http.HttpServletRequest;
import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

@Configuration
@EnableConfigurationProperties(value={OktaOAuth2Properties.class})
@ComponentScan(basePackages={"com.bizunited.platform.core", "com.bizunited.platform.rbac.okta.starter"})
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:")
public class OktaSecurityConfig {
    @Bean(name={"UserDetailsService"})
    public UserDetailsService getUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"CustomAccessDecisionManager"})
    @ConditionalOnMissingBean
    public CustomAccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"authenticationDetailsSource"})
    @ConditionalOnMissingBean(value={AuthenticationDetailsSource.class})
    public AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> getAuthenticationDetailsSource() {
        return new SimpleAuthenticationDetailsSource();
    }

    @Bean(name={"customFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean(value={FilterInvocationSecurityMetadataSource.class})
    public FilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2UserService getOidcUserService() {
        return new OktaOauth2UserSecurityDetailsService();
    }

    @Bean
    @ConditionalOnMissingBean
    public Oauth2UserHandler getOauth2UserHandler() {
        return new SimpleOauth2UserHandler();
    }
}

