/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.handle;

import com.bizunited.platform.rbac.security.starter.handle.HandleOutPut;
import com.bizunited.platform.rbac.security.starter.handle.ResponseCode;
import com.bizunited.platform.rbac.security.starter.handle.ResponseModel;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleAccessDeniedHandler
implements AuthenticationEntryPoint,
AccessDeniedHandler,
InitializingBean,
HandleOutPut {
    private static final String SESSION_USER_MISS = "\u7528\u6237\u5df2\u5931\u6548\u6216\u672a\u767b\u5f55!";
    private static final String SESSION_DENIED = "\u7528\u6237\u65e0\u6743\u8bbf\u95ee\u8be5\u529f\u80fd!";
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private ClientRegistrationRepository clientRegistrationRepository;
    private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = new HttpSessionOAuth2AuthorizationRequestRepository();

    public SimpleAccessDeniedHandler(ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        OAuth2AuthorizationRequest authorizationRequest = this.getOktaOAuth2AuthorizationRequest(request);
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationRequest.getGrantType())) {
            this.authorizationRequestRepository.saveAuthorizationRequest(authorizationRequest, request, response);
        }
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), (Object)authorizationRequest.getAuthorizationRequestUri(), ResponseCode.E601, (Throwable)new IllegalAccessException(SESSION_USER_MISS));
        this.writeResponse(response, result);
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E602, (Throwable)new IllegalAccessException(SESSION_DENIED));
        this.writeResponse(response, result);
    }

    private OAuth2AuthorizationRequest getOktaOAuth2AuthorizationRequest(HttpServletRequest request) {
        OAuth2AuthorizationRequest.Builder builder;
        String registrationId = "okta";
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        if (clientRegistration == null) {
            throw new IllegalArgumentException("Invalid Client Registration with Id: " + registrationId);
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
        } else if (AuthorizationGrantType.IMPLICIT.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.implicit();
        } else {
            throw new IllegalArgumentException("Invalid Authorization Grant Type (" + clientRegistration.getAuthorizationGrantType().getValue() + ") for Client Registration with Id: " + clientRegistration.getRegistrationId());
        }
        String redirectUriStr = this.expandRedirectUri(request, clientRegistration, "login");
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("registration_id", clientRegistration.getRegistrationId());
        OAuth2AuthorizationRequest authorizationRequest = builder.clientId(clientRegistration.getClientId()).authorizationUri(clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(redirectUriStr).scopes(clientRegistration.getScopes()).state(this.stateGenerator.generateKey()).additionalParameters(additionalParameters).build();
        return authorizationRequest;
    }

    private String expandRedirectUri(HttpServletRequest request, ClientRegistration clientRegistration, String action) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("registrationId", clientRegistration.getRegistrationId());
        String baseUrl = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replaceQuery(null).replacePath(request.getContextPath()).build().toUriString();
        uriVariables.put("baseUrl", baseUrl);
        if (action != null) {
            uriVariables.put("action", action);
        }
        return UriComponentsBuilder.fromUriString((String)clientRegistration.getRedirectUriTemplate()).buildAndExpand(uriVariables).toUriString();
    }
}

