package com.bizunited.platform.rbac.okta.starter.service.security;

import com.bizunited.platform.rbac.okta.starter.handle.Oauth2UserHandler;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

import java.util.LinkedList;
import java.util.List;

/**
 * 这个自定义的用户信息查询服务（权限模块使用），用来查询指定的用户详情（包括角色信息）
 * @author paul chan
 * @date 2020-03-13 15:20
 */
public class OktaOauth2UserSecurityDetailsService extends OidcUserService {
  
  @Autowired
  private RoleService roleService;
  @Autowired
  private Oauth2UserHandler oauth2UserHandler;

  @Override
  public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
    OidcUser oidcUser = super.loadUser(userRequest);
    UserVo currentUser = oauth2UserHandler.getLocalUser(oidcUser);
    // 查询用户角色信息
    List<RoleVo> roles;
    roles = this.roleService.findAllByUserId(currentUser.getId(), 0);
    if(roles == null || roles.isEmpty()) {
      throw new UsernameNotFoundException("用户权限状态错误，请联系客服人员！");
    }
    List<SimpleGrantedAuthority> authorities = new LinkedList<>();
    for (RoleVo role : roles) {
      SimpleGrantedAuthority authoritie = new SimpleGrantedAuthority(role.getRoleName());
      authorities.add(authoritie);
    }
    String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
    if(StringUtils.isNotBlank(userNameAttributeName)) {
      return new DefaultOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName);
    }
    return new DefaultOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo());
  }

}
