/*
 * Copyright 2018-Present Okta, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bizunited.platform.rbac.okta.starter.okta;

import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

/**
 * okta针对oauth2.0单点登录的oidc用户资源实现
 * @Author: Paul Chan
 * @Date: 2020-03-10 15:04
 */
final class OktaOidcUserService extends OidcUserService {

    private final String groupClaim;

    OktaOidcUserService(String groupClaim) {
        this.groupClaim = groupClaim;
        this.setOauth2UserService(new OktaOAuth2UserService(groupClaim));
    }

    @Override
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        return UserUtil.decorateUser(user, userRequest, groupClaim);
    }
}