package com.bizunited.platform.rbac.okta.starter.annotations;

import com.bizunited.platform.rbac.okta.starter.configuration.OktaSecurityConfig;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service启用okta的单点登录认证
 * @Author: Paul Chan
 * @Date: 2020-03-10 11:06
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import({OktaSecurityConfig.class})
public @interface EnableNebulaOktaSecurity {


}
