/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.okta;

import com.bizunited.platform.rbac.okta.starter.okta.TokenUtil;
import java.util.HashSet;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.StringUtils;

public final class UserUtil {
    private UserUtil() {
    }

    public static OAuth2User decorateUser(OAuth2User user, OAuth2UserRequest userRequest, String groupClaim) {
        if (!"Okta".equals(userRequest.getClientRegistration().getClientName())) {
            return user;
        }
        HashSet<Object> authorities = new HashSet<Object>(user.getAuthorities());
        authorities.addAll(TokenUtil.tokenScopesToAuthorities(userRequest.getAccessToken()));
        authorities.addAll(TokenUtil.tokenClaimsToAuthorities(user.getAttributes(), groupClaim));
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        return new DefaultOAuth2User(authorities, user.getAttributes(), userNameAttributeName);
    }

    public static OidcUser decorateUser(OidcUser user, OidcUserRequest userRequest, String groupClaim) {
        if (!"Okta".equals(userRequest.getClientRegistration().getClientName())) {
            return user;
        }
        HashSet<Object> authorities = new HashSet<Object>(user.getAuthorities());
        authorities.addAll(TokenUtil.tokenScopesToAuthorities(userRequest.getAccessToken()));
        authorities.addAll(TokenUtil.tokenClaimsToAuthorities(user.getAttributes(), groupClaim));
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        return StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(authorities, user.getIdToken(), user.getUserInfo(), userNameAttributeName) : new DefaultOidcUser(authorities, user.getIdToken(), user.getUserInfo());
    }
}

