package com.bizunited.platform.rbac.okta.starter.configuration;

import com.bizunited.platform.rbac.okta.starter.handle.Oauth2UserHandler;
import com.bizunited.platform.rbac.okta.starter.handle.SimpleOauth2UserHandler;
import com.bizunited.platform.rbac.okta.starter.okta.OktaOAuth2Properties;
import com.bizunited.platform.rbac.okta.starter.service.security.OktaOauth2UserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationDetailsSource;
import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

import javax.servlet.http.HttpServletRequest;

/**
 * okta单点登录的初始化配置
 * @Author: Paul Chan
 * @Date: 2020-03-06 16:17
 */
@Configuration
@EnableConfigurationProperties(OktaOAuth2Properties.class)
@ComponentScan(basePackages= {"com.bizunited.platform.core", "com.bizunited.platform.rbac.okta.starter", "com.bizunited.platform.rbac.server"})
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:", maxInactiveIntervalInSeconds = 28800)
public class OktaSecurityConfig {

  @Bean(name="UserDetailsService")
  public UserDetailsService getUserDetailsService(){
    return new CustomUserSecurityDetailsService();
  }

  /**
   * 接口权限的自定义实现
   * @return
   */
  @Bean(name="CustomAccessDecisionManager")
  @ConditionalOnMissingBean
  public CustomAccessDecisionManager getCustomAccessDecisionManager() {
    return new CustomAccessDecisionManager();
  }

  /**
   * 该接口用来定义登录请求的数据获取方式
   * @return
   */
  @Bean(name="authenticationDetailsSource")
  @ConditionalOnMissingBean(AuthenticationDetailsSource.class)
  public AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> getAuthenticationDetailsSource() {
    return new SimpleAuthenticationDetailsSource();
  }

  @Bean(name="customFilterInvocationSecurityMetadataSource")
  @ConditionalOnMissingBean(FilterInvocationSecurityMetadataSource.class)
  public FilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
    return new CustomFilterInvocationSecurityMetadataSource();
  }

  /**
   * okta的用户服务中心
   * @return
   */
  @Bean
  @SuppressWarnings("rawtypes")
  @ConditionalOnMissingBean
  public OAuth2UserService getOidcUserService() {
    return new OktaOauth2UserSecurityDetailsService();
  }

  /**
   * oauth2的用户处理
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public Oauth2UserHandler getOauth2UserHandler() {
    return new SimpleOauth2UserHandler();
  }


}
