package com.bizunited.platform.rbac.okta.starter.okta;

import com.okta.commons.lang.ApplicationInfo;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;
import java.util.stream.Collectors;

/**
 * 用户header的拦截器，用户请求单点登录服务器时增加header
 * @Author: Paul Chan
 * @Date: 2020-03-09 18:00
 */
public class UserAgentRequestInterceptor implements ClientHttpRequestInterceptor {

  private final static String USER_AGENT_VALUE = ApplicationInfo.get().entrySet().stream()
      .map(e -> e.getKey() + "/" + e.getValue())
      .collect(Collectors.joining(" "));

  @Override
  public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
    request.getHeaders().add(HttpHeaders.USER_AGENT, USER_AGENT_VALUE);
    return execution.execute(request, body);
  }
}