/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.okta.starter.okta;

import com.okta.commons.configcheck.ConfigurationValidator;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(value="okta.oauth2")
public final class OktaOAuth2Properties
implements Validator {
    private final OAuth2ClientProperties clientProperties;
    private String redirectUri;
    private String clientId;
    private String clientSecret;
    private String issuer;
    private Set<String> scopes;
    private String audience = "api://default";
    private String groupsClaim = "groups";

    public OktaOAuth2Properties(@Autowired(required=false) OAuth2ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public String getClientId() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getClientId).orElse(this.clientId);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getClientSecret).orElse(this.clientSecret);
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    public Set<String> getScopes() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getScope).orElse(this.scopes);
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    private Optional<OAuth2ClientProperties.Registration> getRegistration() {
        return Optional.ofNullable(this.clientProperties != null ? (OAuth2ClientProperties.Registration)this.clientProperties.getRegistration().get("okta") : null);
    }

    public boolean supports(Class<?> clazz) {
        return OktaOAuth2Properties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        OktaOAuth2Properties properties = (OktaOAuth2Properties)target;
        if (properties.getClientId() != null) {
            ConfigurationValidator.validateClientId((String)properties.getClientId()).ifInvalid(res -> errors.rejectValue("clientId", res.getMessage()));
        }
        if (properties.getClientSecret() != null) {
            ConfigurationValidator.validateClientSecret((String)properties.getClientSecret()).ifInvalid(res -> errors.rejectValue("clientSecret", res.getMessage()));
        }
        if (properties.getIssuer() != null) {
            ConfigurationValidator.validateIssuer((String)properties.getIssuer()).ifInvalid(res -> errors.rejectValue("issuer", res.getMessage()));
        }
    }
}

