/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.configuration;

import com.bizunited.platform.rbac.security.starter.configuration.HandleOutPut;
import com.bizunited.platform.rbac.security.starter.configuration.ResponseCode;
import com.bizunited.platform.rbac.security.starter.configuration.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="simpleAuthenticationSuccessHandler")
public class SimpleAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler
implements HandleOutPut {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String account = authentication.getName();
        if (StringUtils.isBlank((CharSequence)account)) {
            ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, new IllegalAccessException("not found op user!"));
            this.writeResponse(response, result);
            return;
        }
        UserVo user = this.userService.findByAccount(account);
        if (user == null) {
            ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, new IllegalAccessException("not found op user!"));
            this.writeResponse(response, result);
            return;
        }
        this.userService.updateLastloginTime(user.getAccount());
        user.setLastloginTime(new Date());
        List roles = this.roleService.findAllByUserId(user.getId());
        user.setRoles(new HashSet(roles));
        Collection setCookies = response.getHeaders("Set-Cookie");
        String jsession = null;
        if (setCookies != null) {
            for (String setCookie : setCookies) {
                String value;
                int indexd;
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"persistence=") != -1) {
                    indexd = setCookie.indexOf("=");
                    value = setCookie.substring(indexd + 1);
                    response.setHeader("persistence", value);
                    continue;
                }
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"JSESSIONID=") == -1) continue;
                indexd = setCookie.indexOf("=");
                jsession = value = setCookie.substring(indexd + 1);
            }
            response.setHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence,Cookie");
        }
        if (StringUtils.isBlank(jsession)) {
            HttpSession session = request.getSession();
            jsession = session.getId();
            Cookie cookie = new Cookie("JSESSIONID", jsession);
            cookie.setSecure(true);
            response.addCookie(cookie);
        }
        response.setHeader("JSESSIONID", jsession);
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        result.setData(user);
        this.writeResponse(response, result);
    }
}

