/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.configuration;

import com.bizunited.platform.rbac.security.starter.configuration.SimpleAccessDeniedHandler;
import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterSecurityInterceptor;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableAutoConfiguration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.platform.rbac.security.starter"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${author.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${kuiper.loginUrl}")
    private String loginUrl;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;

    protected void configure(HttpSecurity http) throws Exception {
        SimpleAccessDeniedHandler simpleAccessDeniedHandler = new SimpleAccessDeniedHandler();
        CorsConfigurationSource configurationSource = this.corsConfigurationSource();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().configurationSource(configurationSource).and()).headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(this.ignoreUrls)).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)simpleAccessDeniedHandler).and()).formLogin().loginPage("/v1/formengine/security/loginFail").loginProcessingUrl(this.loginUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).permitAll()).and()).logout().logoutUrl("/v1/formengine/security/logout").logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).rememberMe().tokenValiditySeconds(8640000).rememberMeCookieName("persistence").alwaysRemember(true);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = http.authorizeRequests();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll();
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.customUserDetailsService()).passwordEncoder(this.passwordEncoder());
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        Pbkdf2PasswordEncoder passwordEncoder = new Pbkdf2PasswordEncoder();
        return passwordEncoder;
    }

    @Bean(name={"CustomUserSecurityDetailsService"})
    @ConditionalOnMissingBean
    public CustomUserSecurityDetailsService customUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"CustomAccessDecisionManager"})
    @ConditionalOnMissingBean
    public CustomAccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"CustomFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean
    public CustomFilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean(name={"CustomFilterSecurityInterceptor"})
    @ConditionalOnMissingBean
    public CustomFilterSecurityInterceptor getCustomFilterSecurityInterceptor() {
        return new CustomFilterSecurityInterceptor();
    }
}

