package com.bizunited.platform.rbac.security.starter.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
/**
 * 基于典型单点鉴权的权限安全相关的接口，在这里暴露
 * @author yinwenjie
 */
@RestController("RbacSecurityController")
@RequestMapping("/v1/formengine/security")
public class SecurityController {
  /**
   * 登出成功后的重定向地址
   */
  @Value("${kuiper.logoutUrl:/default/index.html#/login}")
  private String logoutUrl;
  private static final Logger LOGGER = LoggerFactory.getLogger(SecurityController.class);
  /**
   * 该http方法用于登出系统，并按照设定信息，跳转到指定的登陆后页面。所谓登录实际上就是清楚当前系统的cookies信息
   */
  @ApiOperation(value="该http方法用于登出系统，并按照设定信息，跳转到指定的登陆后页面。所谓登录实际上就是清楚当前系统的cookies信息")
  @RequestMapping(value="/logoutSuccess" , method={RequestMethod.GET , RequestMethod.POST})
  public void logoutSuccess(HttpServletRequest request , HttpServletResponse response) {
    Cookie[] allCookies = request.getCookies();
    if(allCookies != null) {
      for(int index = 0 ; index < allCookies.length ; index++){
        Cookie currentCookie = allCookies[index];
        currentCookie.setMaxAge(0);
        response.addCookie(currentCookie);
      }
    }
    
    // 跳转到指定的页面
    try {
      response.sendRedirect(this.logoutUrl);
    } catch (IOException e) {
      LOGGER.error(e.getMessage() , e);
    }
  }
}