/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.configuration;

import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterSecurityInterceptor;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsUtils;

@Configuration
@EnableAutoConfiguration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.platform.rbac", "com.bizunited.platform.core"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${author.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${kuiper.loginUrl}")
    private String loginUrl;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(this.ignoreUrls)).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/v1/rbac/security/loginFail").loginProcessingUrl(this.loginUrl)).failureForwardUrl("/v1/rbac/security/loginFail").successForwardUrl("/v1/rbac/security/loginSuccess").permitAll()).and()).logout().logoutUrl("/v1/rbac/security/logout").logoutSuccessUrl("/v1/rbac/security/logoutSuccess").permitAll().and()).csrf().disable()).rememberMe().tokenValiditySeconds(8640000).rememberMeCookieName("persistence").alwaysRemember(true);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = http.authorizeRequests();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.customUserDetailsService()).passwordEncoder(this.passwordEncoder());
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        Pbkdf2PasswordEncoder passwordEncoder = new Pbkdf2PasswordEncoder();
        return passwordEncoder;
    }

    @Bean(name={"CustomUserSecurityDetailsService"})
    @ConditionalOnMissingBean(value={CustomUserSecurityDetailsService.class})
    public CustomUserSecurityDetailsService customUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"CustomAccessDecisionManager"})
    @ConditionalOnMissingBean(value={CustomAccessDecisionManager.class})
    public CustomAccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"CustomFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean(value={CustomFilterInvocationSecurityMetadataSource.class})
    public CustomFilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean(name={"CustomFilterSecurityInterceptor"})
    @ConditionalOnMissingBean(value={CustomFilterSecurityInterceptor.class})
    public CustomFilterSecurityInterceptor getCustomFilterSecurityInterceptor() {
        return new CustomFilterSecurityInterceptor();
    }
}

