/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.controller;

import com.bizunited.platform.rbac.security.starter.controller.model.ResponseCode;
import com.bizunited.platform.rbac.security.starter.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/security"})
public class SecurityController {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @ApiOperation(value="\u5f53\u767b\u9646\u6210\u529f\u540e\uff0c\u9ed8\u8ba4\u8df3\u8f6c\u5230\u8fd9\u4e2aURL\uff0c\u5e76\u4e14\u8fd4\u56de\u767b\u5f55\u6210\u529f\u540e\u7684\u7528\u6237\u57fa\u672c\u4fe1\u606f\u4e00\u65e6\u767b\u5f55\u6210\u529f\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u4e24\u4e2a\u91cd\u8981\u5c5e\u6027\uff1a<br>1\u3001SESSION\u5c5e\u6027\uff1a\u8be5\u5c5e\u6027\u53ef\u4fdd\u8bc1\u4ece\u6700\u540e\u4e00\u6b21\u670d\u52a1\u5668\u8bf7\u6c42\u5f00\u59cb\u768430\u5206\u949f\u5185\u767b\u5f55\u4fe1\u606f\u6709\u6548(\u524d\u63d0\u662f\u670d\u52a1\u8282\u70b9\u6ca1\u6709\u91cd\u542f)<br>2\u3001persistence\u5c5e\u6027\uff1a\u8be5\u5c5e\u6027\u53ef\u4fdd\u8bc1\u4ece\u6700\u540e\u4e00\u6b21\u767b\u5f55\u64cd\u4f5c\u5f00\u59cb\u7684100\u5929\u5185\u767b\u5f55\u4fe1\u606f\u6709\u6548(\u524d\u63d0\u662f\u670d\u52a1\u8282\u70b9\u6ca1\u6709\u91cd\u542f)<br>\u5ba2\u6237\u7aef\u5e94\u8be5\u81f3\u5c11\u4fdd\u8bc1\u5728\u8fdb\u884cHTTP\u8bf7\u6c42\u65f6\uff0c\u5411\u670d\u52a1\u5668\u4f20\u9012persistence\u5c5e\u6027\u3002\u4f46\u4e3a\u4e86\u4fdd\u8bc1\u670d\u52a1\u7aef\u4e1a\u52a1\u5904\u7406\u6027\u80fd\uff0c\u5e94\u8be5\u4e24\u4e2a\u5c5e\u6027\u90fd\u8fdb\u884c\u4f20\u9012\u3002<br><b>\u8bf7\u6ce8\u610f\uff1a\u6b63\u5e38\u60c5\u51b5\u4e0bSESSION\u5c5e\u6027\u53ef\u80fd\u53d1\u751f\u53d8\u5316\uff0c\u4e00\u65e6\u53d8\u5316\u5ba2\u6237\u7aef\u5e94\u8be5\u5411\u670d\u52a1\u7aef\u4f20\u9012\u6700\u65b0\u7684SESSION\u5c5e\u6027</b></p>\u4e00\u65e6\u767b\u5f55\u6210\u529f\u6216\u8005\u901a\u8fc7persistence\u81ea\u52a8\u91cd\u767b\u5f55\u6210\u529f\u540e\uff0c\u670d\u52a1\u7aef\u5c06\u901a\u8fc7\u4ee5\u4e0b\u4e24\u79cd\u65b9\u5f0f\u5411\u5ba2\u6237\u7aef\u8fd4\u56de\u65b0\u7684SESSION\u5c5e\u6027\u548cpersistence\u5c5e\u6027\uff1a<br>1\u3001http response\u7684header\u4fe1\u606f\u4e2d\uff0c\u5c06\u643a\u5e26\u3002\u7c7b\u4f3c\u4e8e\uff1apersistence =YWRtaW46MTUxNDUxNzA4MjYzNjplYzI0OTFlYWEyNDhkZmIyZWIyNjNjODc3YzM2M2Q0MA \u548c SESSION =54fd02c7-4067-43c9-94f8-5f6e474cd858<br>2\u3001http response\u7684cookies\u4fe1\u606f\u4e2d\uff0c\u5c06\u643a\u5e26\u3002\uff08\u6b64\u79cd\u65b9\u5f0f\u662f\u63a8\u8350\u4f7f\u7528\u7684\u65b9\u5f0f\uff09<br><b>\u6ce8\u610f\uff1a\u4ee5\u4e0a\u63cf\u8ff0\u53ea\u9650\u4e8e\u767b\u5f55\u6210\u529f\u540e\u7684\u8fd4\u56de\u4fe1\u606f\uff0c\u5e76\u4e0d\u662f\u8bf4\u6bcf\u4e00\u6b21\u4e1a\u52a1\u8bf7\u6c42\u64cd\u4f5c\uff0c\u670d\u52a1\u7aef\u90fd\u4f1a\u5411\u5ba2\u6237\u7aef\u8fd9\u6837\u8fd4\u56deSESSION\u5c5e\u6027\u548cpersistence\u5c5e\u6027</b></p>\u4e3a\u4e86\u4fdd\u8bc1\u670d\u52a1\u7aef\u80fd\u591f\u6b63\u786e\u8bc6\u522b\u5230\u5ba2\u6237\u7aef\u5df2\u767b\u5f55\u7684\u7528\u6237\u6743\u9650\u4fe1\u606f\uff0c\u5728\u6b63\u5e38\u7684\u524d\u7aef\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\uff0c\u6bcf\u4e00\u6b21\u5ba2\u6237\u7aef\u7684\u8bf7\u6c42\u90fd\u9700\u8981\u5411\u670d\u52a1\u7aef\u53d1\u9001SESSION\u5c5e\u6027\uff08\u975e\u5fc5\u8981\uff0c\u4f46\u63a8\u8350\uff09\u548cpersistence\u5c5e\u6027<br>\u5ba2\u6237\u7aef\u53ef\u4ee5\u4f7f\u7528\u4ee5\u4e0b\u65b9\u5f0f\uff0c\u5411\u670d\u52a1\u7aef\u53d1\u9001SESSION\u5c5e\u6027\u548cpersistence\u5c5e\u6027\uff1a<br>1\u3001\u76f4\u63a5\u4f7f\u7528http request\u7684cookies\u53d1\u9001\u3002\uff08\u6b64\u79cd\u65b9\u5f0f\u662f\u63a8\u8350\u4f7f\u7528\u7684\u65b9\u5f0f\uff09<br>")
    @RequestMapping(value={"/loginSuccess"}, method={RequestMethod.POST})
    public ResponseModel loginSuccess(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = authentication.getName();
        if (StringUtils.isEmpty((CharSequence)account)) {
            ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode._501, new IllegalAccessException("not found op user!"));
            return result;
        }
        UserVo user = this.userService.findByAccount(account);
        if (user == null) {
            ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode._501, new IllegalAccessException("not found op user!"));
            return result;
        }
        List roles = this.roleService.findAllByUserId(user.getId());
        user.setRoles(new HashSet(roles));
        Collection setCookies = response.getHeaders("Set-Cookie");
        String jsession = null;
        if (setCookies != null) {
            for (String setCookie : setCookies) {
                String value;
                int indexd;
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"persistence=") != -1) {
                    indexd = setCookie.indexOf("=");
                    value = setCookie.substring(indexd + 1);
                    response.setHeader("persistence", value);
                    continue;
                }
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"JSESSIONID=") == -1) continue;
                indexd = setCookie.indexOf("=");
                jsession = value = setCookie.substring(indexd + 1);
            }
            response.setHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence,Cookie");
        }
        if (StringUtils.isBlank(jsession)) {
            HttpSession session = request.getSession();
            jsession = session.getId();
            Cookie cookie = new Cookie("JSESSIONID", jsession);
            response.addCookie(cookie);
        }
        response.setHeader("JSESSIONID", jsession);
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode._0, null);
        result.setData(user);
        return result;
    }

    @ApiOperation(value="\u7531\u4e8e\u540e\u7aef\u63d0\u4f9b\u7684\u90fd\u662frestful\u63a5\u53e3\uff0c\u5e76\u6ca1\u6709\u76f4\u63a5\u8df3\u8f6c\u7684\u9875\u9762<br>\u6240\u4ee5\u53ea\u8981\u8bbf\u95ee\u7684url\u6ca1\u6709\u901a\u8fc7\u6743\u9650\u8ba4\u8bc1\uff0c\u5c31\u8df3\u5230\u8fd9\u4e2a\u8bf7\u6c42\u4e0a\uff0c\u5e76\u76f4\u63a5\u6392\u9664\u6743\u9650\u5f02\u5e38")
    @RequestMapping(value={"/loginFail"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseModel loginFail() throws IllegalAccessException {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode._501, new IllegalAccessException("\u7528\u6237\u5df2\u5931\u6548\u6216\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!"));
        return result;
    }

    @ApiOperation(value="\u6210\u529f\u767b\u51fa")
    @RequestMapping(value={"/logoutSuccess"}, method={RequestMethod.GET})
    public ResponseModel logoutSuccess() {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode._0, null);
        return result;
    }
}

