/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.configuration;

import com.bizunited.platform.rbac.security.starter.handle.SimpleAccessDeniedHandler;
import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterSecurityInterceptor;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationDetailsSource;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableAutoConfiguration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.platform.rbac", "com.bizunited.platform.core"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${rbac.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${rbac.loginUrl}")
    private String loginUrl;
    @Value(value="${rbac.logoutUrl}")
    private String logoutUrl;
    @Autowired
    private CustomUserSecurityDetailsService userDetailsService;
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private SimpleAuthenticationDetailsSource authenticationDetailsSource;
    @Autowired
    private CustomAccessDecisionManager accessDecisionManager;
    @Autowired
    private SimpleAuthenticationProvider authenticationProvider;
    @Autowired
    private CustomFilterInvocationSecurityMetadataSource securityMetadataSource;
    public static final String[] DEFAULT_IGNOREURLS = new String[]{"/default/**", "/static/**", "/v1/kuiper/templatevisibilities/findDetailsByTemplateId", "/v1/kuiper/templates/findByConditions", "/v1/nebula/checkCodes", "/v1/nebula/validateCodes"};

    protected void configure(HttpSecurity http) throws Exception {
        CustomFilterSecurityInterceptor filterSecurityInterceptor = new CustomFilterSecurityInterceptor(this.securityMetadataSource, this.accessDecisionManager, super.authenticationManager());
        CorsConfigurationSource configurationSource = this.corsConfigurationSource();
        SimpleAccessDeniedHandler simpleAccessDeniedHandler = new SimpleAccessDeniedHandler();
        ArrayList currentIgnoreUrls = new ArrayList();
        if (this.ignoreUrls != null && this.ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])this.ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])DEFAULT_IGNOREURLS));
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.addFilterAt((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class).cors().configurationSource(configurationSource).and()).headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(currentIgnoreUrls.toArray(new String[0]))).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)simpleAccessDeniedHandler).and()).formLogin().loginPage("/v1/rbac/loginFail").loginProcessingUrl(this.loginUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).authenticationDetailsSource((AuthenticationDetailsSource)this.authenticationDetailsSource)).permitAll()).and()).logout().logoutUrl(this.logoutUrl).logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).rememberMe().tokenValiditySeconds(8640000).rememberMeCookieName("persistence").alwaysRemember(true);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    @Bean(name={"customUserSecurityDetailsService"})
    @ConditionalOnMissingBean(value={CustomUserSecurityDetailsService.class})
    public CustomUserSecurityDetailsService customUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"passwordEncoder"})
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        Pbkdf2PasswordEncoder passwordEncoder = new Pbkdf2PasswordEncoder();
        return passwordEncoder;
    }

    @Bean(name={"customAccessDecisionManager"})
    @ConditionalOnMissingBean(value={CustomAccessDecisionManager.class})
    public CustomAccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"customFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean(value={CustomFilterInvocationSecurityMetadataSource.class})
    public CustomFilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

