package com.bizunited.platform.rbac.security.starter.handle;
import io.swagger.annotations.ApiModel;
/**
 * 统一返回数据对象（对本次请求执行的操作结果是否成功 进行描述 flag=1时执行成功）
 * @author yinwenjie
 */
@ApiModel("统一返回数据对象")
class ResponseModel {
  /** 时间 */
  private Long timestamp;
  /**
   * 正常情况下返回的数据在这里进行记录和描述
   */
  private Object data;
  /**
   * 响应标记，正常情况下是0
   */
  private ResponseCode responseCode = ResponseCode.E0;
  /**
   * 只有响应标记为0的时候，这里才能为true
   */
  private Boolean success = true;
  /**
   * 异常信息描述,后台原始的errorMessage
   */
  private String errorMsg;
  /**
   * 前端业务操作者能够看懂的异常信息
   */
  private String message;
  
  public ResponseModel() {
  }
  public ResponseModel(Long timestamp, Object data, ResponseCode responseCode, Throwable errorMsg) {
    this.timestamp = timestamp;
    this.data = data;
    this.responseCode = responseCode;
    if(this.responseCode == ResponseCode.E0) {
      this.success = true;
    } else {
      this.success = false;
    }
    if(errorMsg != null) {
      this.errorMsg = errorMsg.getMessage();
    }
  }
  
  public Long getTimestamp() {
    return timestamp;
  }
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }
  public Object getData() {
    return data;
  }
  public void setData(Object data) {
    this.data = data;
  }
  public ResponseCode getResponseCode() {
    return responseCode;
  }
  public String getErrorMsg() {
    return errorMsg;
  }
  public void setErrorMsg(String errorMsg) {
    this.errorMsg = errorMsg;
  }
  public void setResponseCode(ResponseCode responseCode) {
    this.responseCode = responseCode;
  }
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }
}