package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.rbac.server.vo.UserVo;

/**
 * 用户名 + 短信验证码 + 校验码 的登录鉴权方式
 * @author yinwenjie
 */
@Component("simpleUserAndCodeDecision")
public class SimpleUserAndCodeDecision extends AbstractAuthenticationDecision {

  @Override
  public UserVo authenticate(LoginDetails loginDetails) {
    /*
     * .处理过程如下：
     * 1、首先通过用户名、查询当前用户的存在性
     * 2、然后再判断当前用户的登录校验码是否正确
     * 3、最后判断当前用户的短信验证码是否正确
     * */
    // 1、======
    String username = loginDetails.getUsername();
    UserVo currentUser = this.validateUserName(username);
    // 2、======
    String sessionId = loginDetails.getSessionId();
    String smsVerificationCode = loginDetails.getSmsVerificationCode();
    super.validateSmsVerificationCode(sessionId, smsVerificationCode);
    // 3、======
    String checkCode = loginDetails.getCheckCode();
    super.validateCheckCode(sessionId, checkCode);
    
    return currentUser;
  }

  @Override
  public DecisionTypes type() {
    return DecisionTypes.USERANDCODE;
  }
}
