package com.bizunited.platform.rbac.security.starter.service.security;

import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

/**
 * 该类描述了登录操作时传递的自定义表单信息
 * @author yinwenjie
 */
public class LoginDetails extends WebAuthenticationDetails {
  /**
   * 
   */
  private static final long serialVersionUID = -8450931284609163341L;

  /**
   * 登录方式类型：1、典型的用户名+密码方式；2、典型的用户名 + 密码 + 校验码方式；3、用户名 + 短信验证码 + 校验码方式；
   * 4、手机号 + 密码方式；5、手机号 + 短信验证码；6、手机号 + 短信验证码 + 校验码方式</br>
   * 当然，这里type也可以为null或者小于等于0的一个数，这种情况下，登录逻辑将采用第1中鉴权方式
   */
  private Integer type = null;
  /**
   * 输入的用户名
   */
  private String username;
  /**
   * 输入的明文密码
   */
  private String password;
  /**
   * 输入的校验码（一般用于放置机器人操作）
   */
  private String checkCode;
  /**
   * 输入的短信验证码
   */
  private String smsVerificationCode;
  /**
   * 输入的手机号
   */
  private String phone;
  /**
   * 用户在上下文会话中的唯一标识。该信息不需要调用者传递，而LoginDetails内部将进行记录
   */
  private String sessionId;
  
  public LoginDetails(HttpServletRequest request) {
    super(request);
    // 确认典型鉴权方式的类型
    String typeValue =  request.getParameter("type");
    // 如果条件成立，则使用默认的逻辑规则类型“1”作为鉴权模式
    if(StringUtils.isBlank(typeValue) || !isNumeric(typeValue)) {
      typeValue = "1";
    }
    this.sessionId = request.getSession().getId();
    this.type = Integer.parseInt(typeValue);
    // 可能输入的手机号
    this.username = request.getParameter("username");
    // 可能输入的明文密码
    this.password = request.getParameter("password");
    // 可能输入的校验码
    this.checkCode = request.getParameter("checkCode");
    // 可能输入的短信验证码
    this.smsVerificationCode = request.getParameter("smsVerificationCode");
    // 可能输入的手机号
    this.phone = request.getParameter("phone");
  }
  /**
   * .该正则表达式可以匹配所有的数字 包括负数
   * @param str
   * @return
   */
  private boolean isNumeric(String str) {
    Pattern pattern = Pattern.compile("^[0-9]+$");
    return pattern.matcher(str).find();
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public String getUsername() {
    return username;
  }
  public void setUsername(String username) {
    this.username = username;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }
  public String getCheckCode() {
    return checkCode;
  }
  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }
  public String getSmsVerificationCode() {
    return smsVerificationCode;
  }
  public void setSmsVerificationCode(String smsVerificationCode) {
    this.smsVerificationCode = smsVerificationCode;
  }
  public String getPhone() {
    return phone;
  }
  public void setPhone(String phone) {
    this.phone = phone;
  }
  public String getSessionId() {
    return sessionId;
  }
  @Override
  public String toString() {
    return "LoginDetails [type=" + type + ", username=" + username + ", password=" + password
        + ", checkCode=" + checkCode + ", smsVerificationCode=" + smsVerificationCode + ", phone="
        + phone + ", sessionId=" + sessionId + "]";
  }
}
