package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.rbac.server.vo.UserVo;

/**
 * 典型的用户名 + 密码 + 校验码方式
 * @author yinwenjie
 */
@Component("simpleUserAndPasswordAndCCodeDecision")
public class SimpleUserAndPasswordAndCCodeDecision extends AbstractAuthenticationDecision {
  
  @Override
  public UserVo authenticate(LoginDetails loginDetails) {
    /*
     * 1、首先使用父级方法，检查用户名和密码是否正确
     * 2、然后使用父级方法，检查指定用户、指定登录业务下的校验码是否正常
     * */
    // 1、=====
    String userName = loginDetails.getUsername();
    String inputPassword = loginDetails.getPassword();
    UserVo currentUser = super.validateUserNameAndPassword(userName, inputPassword);
    // 2、=====
    String checkCode = loginDetails.getCheckCode();
    String sessionId = loginDetails.getSessionId();
    super.validateCheckCode(sessionId, checkCode);
    return currentUser;
  }

  @Override
  public DecisionTypes type() {
    return DecisionTypes.USERANDPASSWORDANDCCODE;
  }
}
