/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.service.security;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class CustomAccessDecisionManager
implements AccessDecisionManager {
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (configAttributes == null || configAttributes.isEmpty()) {
            throw new AccessDeniedException("not author!");
        }
        for (ConfigAttribute configAttribute : configAttributes) {
            String roleName = configAttribute.getAttribute();
            if (!StringUtils.equals((CharSequence)roleName, (CharSequence)"ANONYMOUS")) continue;
            return;
        }
        Collection currentAuthors = authentication.getAuthorities();
        if (currentAuthors == null || currentAuthors.isEmpty()) {
            throw new AccessDeniedException("not found any author from this single in user!");
        }
        for (GrantedAuthority grantedAuthority : currentAuthors) {
            for (String ignoreMethodCheckRole : this.ignoreMethodCheckRoles) {
                if (!StringUtils.equals((CharSequence)grantedAuthority.getAuthority(), (CharSequence)ignoreMethodCheckRole)) continue;
                return;
            }
        }
        for (ConfigAttribute securityConfig : configAttributes) {
            for (GrantedAuthority grantedAuthority : currentAuthors) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)securityConfig.getAttribute(), (CharSequence)grantedAuthority.getAuthority())) continue;
                return;
            }
        }
        throw new AccessDeniedException("not author!");
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

