/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.service.security;

import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CustomFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final SecurityConfig ANONYMOUS_CONFIG = new SecurityConfig("ANONYMOUS");
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private RoleService roleService;
    @Value(value="${rbac.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        ArrayList<ConfigAttribute> configs = new ArrayList<ConfigAttribute>();
        FilterInvocation filterInvocation = (FilterInvocation)object;
        HttpServletRequest httpRequest = filterInvocation.getHttpRequest();
        ArrayList currentIgnoreUrls = new ArrayList();
        if (this.ignoreUrls != null && this.ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])this.ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])com.bizunited.platform.rbac.security.starter.configuration.SecurityConfig.DEFAULT_IGNOREURLS));
        for (String ignoreUrl : currentIgnoreUrls) {
            AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
            if (!requestMatcher.matches(httpRequest)) continue;
            configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
            return configs;
        }
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        Set requestMappings = pathMapping.keySet();
        ArrayList matchingResults = Lists.newArrayList();
        for (RequestMappingInfo requestMappingInfo : requestMappings) {
            RequestMappingInfo current = requestMappingInfo.getMatchingCondition(httpRequest);
            if (current == null) continue;
            matchingResults.add(current);
        }
        if (matchingResults.isEmpty()) {
            configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
            return configs;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AccessDeniedException("not author!");
        }
        Collection currentRoles = authentication.getAuthorities();
        if (this.ignoreMethodCheckRoles != null && currentRoles != null && !currentRoles.isEmpty()) {
            Set currentRoleNames = currentRoles.stream().map(Object::toString).collect(Collectors.toSet());
            for (String currentRoleName : currentRoleNames) {
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)currentRoleName, (CharSequence[])this.ignoreMethodCheckRoles)) continue;
                configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
                return configs;
            }
        }
        ArrayList currentCompetences = Lists.newArrayList();
        for (RequestMappingInfo requestMappingInfo : matchingResults) {
            Set resources = requestMappingInfo.getPatternsCondition().getPatterns();
            if (resources == null || resources.isEmpty()) continue;
            for (String resource : resources) {
                List dbCompetences = this.competenceService.findByResource(resource, Integer.valueOf(1));
                if (dbCompetences == null || dbCompetences.isEmpty()) continue;
                currentCompetences.addAll(dbCompetences);
            }
        }
        if (currentCompetences.isEmpty()) {
            configs.add((ConfigAttribute)ANONYMOUS_CONFIG);
            return configs;
        }
        String currentMethod = httpRequest.getMethod();
        for (CompetenceVo competence : currentCompetences) {
            List roles;
            String methods = competence.getMethods();
            if (methods.indexOf(currentMethod) == -1 || (roles = this.roleService.findByCompetenceId(competence.getId())) == null || roles.isEmpty()) continue;
            for (RoleVo role : roles) {
                SecurityConfig securityConfig = new SecurityConfig(role.getRoleName());
                configs.add((ConfigAttribute)securityConfig);
            }
        }
        if (configs.isEmpty()) {
            throw new AccessDeniedException("not author!");
        }
        return configs;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return Collections.emptyList();
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

