package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.rbac.server.vo.UserVo;

/**
 * 最基本的用户名 + 密码方式的鉴权决策器
 * @author yinwenjie
 */
@Component("simpleUserAndPasswordDecision")
public class SimpleUserAndPasswordDecision extends AbstractAuthenticationDecision {
  
  @Override
  public UserVo authenticate(LoginDetails loginDetails) {
    String userName = loginDetails.getUsername();
    String inputPassword = loginDetails.getPassword();
    return super.validateUserNameAndPassword(userName, inputPassword);
  }

  @Override
  public DecisionTypes type() {
    return DecisionTypes.USERANDPASSWORD;
  }
}