package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import org.springframework.stereotype.Component;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.rbac.server.vo.UserVo;

/**
 * 手机号 + 密码的登录鉴权方式
 * @author yinwenjie
 */
@Component("simplePhoneAndPasswordDecision")
public class SimplePhoneAndPasswordDecision extends AbstractAuthenticationDecision {

  @Override
  public UserVo authenticate(LoginDetails loginDetails) {
    String phone = loginDetails.getPhone();
    String inputPassword = loginDetails.getPassword();
    return super.validatePhoneAndPassword(phone, inputPassword);
  }

  @Override
  public DecisionTypes type() {
    return DecisionTypes.PHONEANDPASSWORD;
  }
}